/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.splash;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.element.elements.splash.SplashTextEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.splash.SplashTextElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.events.ModReloadEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenStartingEvent;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SplashTextElementBuilder
extends ElementBuilder<SplashTextElement, SplashTextEditorElement> {
    public final Map<String, SplashTextElement> splashCache = new HashMap<String, SplashTextElement>();
    public boolean isNewMenu = true;
    protected class_437 lastScreen = null;

    public SplashTextElementBuilder() {
        super("splash_text");
        EventHandler.INSTANCE.registerListenersOf(this);
    }

    @EventListener
    public void onInitScreenPre(InitOrResizeScreenStartingEvent e) {
        this.isNewMenu = this.lastScreen == null || this.lastScreen.getClass() != e.getScreen().getClass();
        this.lastScreen = e.getScreen();
    }

    @EventListener
    public void onModReloaded(ModReloadEvent e) {
        this.splashCache.clear();
    }

    @Override
    @NotNull
    public SplashTextElement buildDefaultInstance() {
        SplashTextElement i = new SplashTextElement(this);
        i.baseWidth = 100;
        i.baseHeight = 20;
        return i;
    }

    @Override
    public SplashTextElement deserializeElement(@NotNull SerializedElement serialized) {
        String bounce;
        String scale;
        String shadow;
        String baseColor;
        String refresh;
        String rotation;
        SplashTextElement element = this.buildDefaultInstance();
        String sourceMode = serialized.getValue("source_mode");
        if (sourceMode != null) {
            element.sourceMode = SplashTextElement.SourceMode.getByName(sourceMode);
            if (element.sourceMode == null) {
                element.sourceMode = SplashTextElement.SourceMode.DIRECT_TEXT;
            }
        }
        element.source = serialized.getValue("source");
        if (element.sourceMode == SplashTextElement.SourceMode.TEXT_FILE) {
            element.textFileSupplier = SplashTextElementBuilder.deserializeTextResourceSupplier(element.source);
        }
        if ((rotation = serialized.getValue("rotation")) != null && MathUtils.isFloat((String)rotation)) {
            element.rotation = Float.parseFloat(rotation);
        }
        if ((refresh = serialized.getValue("refresh")) != null && refresh.equalsIgnoreCase("true")) {
            element.refreshOnMenuReload = true;
        }
        if ((baseColor = serialized.getValue("base_color")) != null) {
            element.baseColor = DrawableColor.of(baseColor);
        }
        if ((shadow = serialized.getValue("shadow")) != null && shadow.equalsIgnoreCase("false")) {
            element.shadow = false;
        }
        if ((scale = serialized.getValue("scale")) != null && MathUtils.isFloat((String)scale)) {
            element.scale = Float.parseFloat(scale);
        }
        if ((bounce = serialized.getValue("bouncing")) != null && bounce.equalsIgnoreCase("false")) {
            element.bounce = false;
        }
        return element;
    }

    @Override
    protected SerializedElement serializeElement(@NotNull SplashTextElement element, @NotNull SerializedElement serializeTo) {
        if (element.sourceMode == SplashTextElement.SourceMode.TEXT_FILE && element.textFileSupplier != null) {
            serializeTo.putProperty("source", element.textFileSupplier.getSourceWithPrefix());
        } else {
            serializeTo.putProperty("source", element.source);
        }
        serializeTo.putProperty("source_mode", element.sourceMode.name);
        serializeTo.putProperty("scale", "" + element.scale);
        serializeTo.putProperty("shadow", "" + element.shadow);
        serializeTo.putProperty("rotation", "" + element.rotation);
        serializeTo.putProperty("base_color", element.baseColor.getHex());
        serializeTo.putProperty("refresh", "" + element.refreshOnMenuReload);
        serializeTo.putProperty("bouncing", "" + element.bounce);
        return serializeTo;
    }

    @Override
    @NotNull
    public SplashTextEditorElement wrapIntoEditorElement(@NotNull SplashTextElement element, @NotNull LayoutEditorScreen editor) {
        return new SplashTextEditorElement(element, editor);
    }

    @Override
    @NotNull
    public class_2561 getDisplayName(@Nullable AbstractElement element) {
        if (element instanceof SplashTextElement) {
            SplashTextElement e = (SplashTextElement)element;
            if (e.renderText != null) {
                return class_2561.method_43470((String)e.renderText);
            }
        }
        return class_2561.method_43471((String)"fancymenu.element.elements.splash_text");
    }

    @Override
    @Nullable
    public class_2561[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines("fancymenu.element.elements.splash_text.desc", new String[0]);
    }
}

